unit Unit1;

// =========================================================================
//  1. 
//  2.  
//  3.  
//                   ()  ..
// =========================================================================

interface

uses
  //  
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Menus, ExtCtrls, ComCtrls, Buttons, ImgList, StdCtrls, ToolWin,
  CheckLst,
  //  
  MainData, PictureTools, Present35, EditorCTRL,
  PictureShow, FlyStr35, AboutMain;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    MMFiles: TMenuItem;
    MMOpenPresent: TMenuItem;
    MMExit: TMenuItem;
    MMView: TMenuItem;
    StatusBar1: TStatusBar;
    MMAbout: TMenuItem;
    MMOpenSlide: TMenuItem;
    N11: TMenuItem;
    MMFullScreen: TMenuItem;
    MMAutoSize: TMenuItem;
    MMProportional: TMenuItem;
    MMEditor: TMenuItem;
    ImageListButtons: TImageList;
    ImgListTree: TImageList;
    Splitter1: TSplitter;
    PanelNavigation: TPanel;
    ToolBar1: TToolBar;
    Tool1Divider1: TToolButton;
    T1BtnShowNavigationPanel: TToolButton;
    T1BtnHideNavigationPanel: TToolButton;
    Tool1Divider2: TToolButton;
    TreeView1: TTreeView;
    PanelImg: TPanel;
    Image1: TImage;
    CheckListBox1: TCheckListBox;
    T1BtnStop: TToolButton;
    T1BtnToPrev: TToolButton;
    T1BtnToFirst: TToolButton;
    T1BtnToLast: TToolButton;
    T1BtnToNext: TToolButton;
    T1BtnPlay: TToolButton;
    MMOpenShow: TMenuItem;
    N4: TMenuItem;
    T1BtnPresent: TToolButton;
    T1BtnPicShow: TToolButton;
    ToolButton3: TToolButton;
    CbBoxShowTemp: TComboBox;
    ToolButton1: TToolButton;
    Timer1: TTimer;
    PanelFlyStr: TPanel;
    ImgFlyStr: TImage;
    FontDialog1: TFontDialog;
    MMFlyStrLoad: TMenuItem;
    MMFlayStrEnabled: TMenuItem;
    procedure MMOpenPresentClick(Sender: TObject);
    procedure MMExitClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure MMAboutClick(Sender: TObject);
    procedure MMEditorClick(Sender: TObject);
    procedure T1BtnShowNavigationPanelClick(Sender: TObject);
    procedure T1BtnHideNavigationPanelClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure MMOpenSlideClick(Sender: TObject);
    procedure MMFullScreenClick(Sender: TObject);
    procedure FormKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure PanelImgResize(Sender: TObject);
    procedure MMProportionalClick(Sender: TObject);
    procedure MMAutoSizeClick(Sender: TObject);
    procedure T1BtnToFirstClick(Sender: TObject);
    procedure T1BtnToPrevClick(Sender: TObject);
    procedure T1BtnStopClick(Sender: TObject);
    procedure T1BtnPlayClick(Sender: TObject);
    procedure T1BtnToNextClick(Sender: TObject);
    procedure T1BtnToLastClick(Sender: TObject);
    procedure MMOpenShowClick(Sender: TObject);
    procedure T1BtnPresentClick(Sender: TObject);
    procedure T1BtnPicShowClick(Sender: TObject);
    procedure CbBoxShowTempClick(Sender: TObject);
    procedure MMFlyStrLoadClick(Sender: TObject);
    procedure MMFlayStrEnabledClick(Sender: TObject);
  private
    //  
    procedure ReFullScreen();
    //     
    procedure NavigatorOnOff(RqOn : boolean);
    //  
    procedure PresentActivate();
    //   
    procedure PictureShowActivate();
  public
    { Public declarations }
  end;
var
  Form1: TForm1;

implementation

{$R *.dfm}


// =========================================================================
//    
// =========================================================================
// -------------------------------------------------------------------------
var //  
    Present  : TPresentation;   //  
    PresentActive : boolean;    //  -  

var //  
    PictShow : TPictureShow;
    PictShowActive : boolean;   //  -   

var //   
    FlyStr : TFlyStr;

// -------------------------------------------------------------------------
var //       .   
    FormWidth          : integer;  //  
    FormHeight         : integer;  //  

// =========================================================================
//      
// =========================================================================



procedure TForm1.MMFlayStrEnabledClick(Sender: TObject);
begin
    MMFlayStrEnabled.Checked := not MMFlayStrEnabled.Checked;
    FlyStr.FlyStrON(MMFlayStrEnabled.Checked);
end;

procedure TForm1.MMFlyStrLoadClick(Sender: TObject);
begin
    FlyStr.LoadFlyStr();
    MMFlayStrEnabled.Checked := True;
end;


// =========================================================================
//   
// =========================================================================
// -------------------------------------------------------------------------
//    
function GetApplicationDirectory() : string;
begin
   Result := Application.ExeName;
   Result := ExtractFileDir(Result);
end;
// -------------------------------------------------------------------------
//    
function GetStartDidApplication() : string;
begin
   Result := GetApplicationDirectory();
   ApplicationDir := Result;
end;

// =========================================================================
//    
// =========================================================================
// -------------------------------------------------------------------------
// 27.10.2016
// 
procedure TForm1.FormCreate(Sender: TObject);
begin
  // -----------------------
  //    Image  PanelImg
  Image1.Align    := alNone;
  Image1.AutoSize := False;
  Image1.Left := 2;
  Image1.Top  := 2;
  Image1.Anchors  := [akLeft,akTop];
  PanelImg.Align   := alClient;
  // -----------------------
  //   ToolBar1
  ToolBar1.Color := RGB(131,153,177);  //   clBtnFace
  // -----------------------
  //     
  Self.KeyPreview     := True;
  // -----------------------
  //    
  GetStartDidApplication();
  // -----------------------
  //   
  Present := TPresentation.Create(Image1, TreeView1, StatusBar1);
  // -----------------------
  //   
  Present.AutoSize     := True;    //   
  Present.Proportional := True;    //    
  // -----------------------
  //   
  PictShow := TPictureShow.Create(Image1, CheckListBox1, StatusBar1);
  // -----------------------
  //    
  FlyStr := TFlyStr.Create(PanelFlyStr, ImgFlyStr);
  // -----------------------
  //      
  MMAutoSize.Checked      := Present.AutoSize;
  MMProportional.Enabled  := Present.AutoSize;
  MMProportional.Checked  := Present.Proportional;
  // -----------------------
  //  
   PresentActivate();
  // -----------------------
  // InitFlyStr();
end;
// -------------------------------------------------------------------------
// 27.10.2016
// 
procedure TForm1.FormDestroy(Sender: TObject);
begin
   FlyStr.Free;
   Present.Free;
   PictShow.Free;
end;
// -------------------------------------------------------------------------
//   
procedure TForm1.MMExitClick(Sender: TObject);
begin
  Self.Close;
end;
// =========================================================================
//    
// =========================================================================
// -------------------------------------------------------------------------
// 04.11.2016
//     
procedure TForm1.NavigatorOnOff(RqOn : boolean);
begin
   T1BtnToFirst.Visible := RqOn;
   T1BtnToPrev.Visible := RqOn;
   T1BtnStop.Visible := RqOn;
   T1BtnPlay.Visible := RqOn;
   T1BtnToNext.Visible := RqOn;
   T1BtnToLast.Visible := RqOn;
   CbBoxShowTemp.Visible := RqOn;
end;
// -------------------------------------------------------------------------
// 04.11.2016
//  
procedure TForm1.PresentActivate();
begin
   //   
   PictShowActive := False;
   if Assigned(PictShow)
   then begin
      PictShow.ShowStop;
      PictShow.ImageClear;
   end;
   //  
   NavigatorOnOff(False);
   CheckListBox1.Visible := False;
   CheckListBox1.Align := alNone;
   TreeView1.Align := alClient;
   TreeView1.Visible := True;
   //  
   if Assigned(Present)
   then begin
      PresentActive := True;
      Present.PresentOnOf(True);
      Present.ShowInd := 0;
   end;
end;
// -------------------------------------------------------------------------
// 04.11.2016
//   
procedure TForm1.PictureShowActivate();
begin
   //  
   PresentActive := False;
   if Assigned(Present)
   then begin
      Present.PresentOnOf(False);
      Present.ImageClear;
   end;
   //  
   TreeView1.Visible := False;
   TreeView1.Align := alNone;
   CheckListBox1.Align := alClient;
   CheckListBox1.Visible := True;
   NavigatorOnOff(True);
   //   
   if Assigned(PictShow)
   then begin
      PictShowActive := True;
      PictShow.ShowCurrentImage;
      PictShow.ShowPlay;
   end;
end;
// =========================================================================
//   
// =========================================================================
// -------------------------------------------------------------------------
// 04.11.2016
//  
procedure TForm1.T1BtnPresentClick(Sender: TObject);
begin
   PresentActivate();
end;
// -------------------------------------------------------------------------
// 04.11.2016
//   
procedure TForm1.T1BtnPicShowClick(Sender: TObject);
begin
   PictureShowActivate();
end;
// =========================================================================
//        
// =========================================================================
// -------------------------------------------------------------------------
// 27.10.2016
//   
procedure TForm1.MMEditorClick(Sender: TObject);
begin
  FormTreeSlideEditor.Show;
end;
// -------------------------------------------------------------------------
// 27.10.2016
//  
procedure TForm1.MMAboutClick(Sender: TObject);
begin
  FormAbout.ShowModal;
end;
// =========================================================================
//     
// =========================================================================
// -------------------------------------------------------------------------
// 27.10.2016
//       
procedure TForm1.T1BtnShowNavigationPanelClick(Sender: TObject);
begin
  PanelNavigation.Visible := True;
end;
// -------------------------------------------------------------------------
// 27.10.2016
//         
procedure TForm1.T1BtnHideNavigationPanelClick(Sender: TObject);
begin
   PanelNavigation.Visible := False;
end;
// =========================================================================
//    RESIZE   
// =========================================================================
// -------------------------------------------------------------------------
// 04.11.2016
//          
procedure TForm1.PanelImgResize(Sender: TObject);
begin
  if Assigned(Present) and PresentActive
  then begin
     if Present.ShowOK and (Present.ShowFileName <> '')
     then begin
        //     
        Present.ReShowCurrentImage();
      end;
  end;
  if Assigned(PictShow) and PictShowActive
  then PictShow.ShowCurrentImage;
end;
// -------------------------------------------------------------------------
// 27.10.2016
//      
procedure TForm1.ReFullScreen();
begin
   if not Assigned(Present) then Exit;
   if not MMFullScreen.Checked
   then begin
      //     
      FormWidth  := Form1.Width;
      FormHeight := Form1.Height;
      Form1.BorderStyle := bsNone;
      Form1.Align := alClient;
      StatusBar1.Visible := False;
      // --------------------------------------
      //    
      if Assigned(Present) and PresentActive
      then Present.ReShowCurrentImage();
      if Assigned(PictShow) and PictShowActive
      then PictShow.ShowCurrentImage;
      // --------------------------------------
      MMFullScreen.Checked := True;
   end
   else begin
      //    
      Form1.BorderStyle := bsSizeable;
      Form1.Align  := alNone;
      Form1.Width  := FormWidth;
      Form1.Height := FormHeight;
      Form1.Position := poDesktopCenter;
      StatusBar1.Visible := True;
      // --------------------------------------
      //    
      if Assigned(Present) and PresentActive
      then Present.ReShowCurrentImage();
      if Assigned(PictShow) and PictShowActive
      then PictShow.ShowCurrentImage;
      // --------------------------------------
      MMFullScreen.Checked := False;
   end;
end;
// -------------------------------------------------------------------------
// 27.10.2016
//    
procedure TForm1.MMFullScreenClick(Sender: TObject);
begin
   ReFullScreen();
end;
// -------------------------------------------------------------------------
// 27.10.2016
//    
procedure TForm1.FormKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if (Key = VK_RETURN) and (Shift = [ssAlt])
  then ReFullScreen();
end;
// =========================================================================
//  
// =========================================================================
// -------------------------------------------------------------------------
// 27.10.2016
//   
procedure TForm1.MMOpenPresentClick(Sender: TObject);
begin
  if not Assigned(Present) then Exit;
  Present.LoadPresentation(ApplicationDir);
  PresentActivate();
end;
// -------------------------------------------------------------------------
// 27.10.2016
//    
procedure TForm1.MMAutoSizeClick(Sender: TObject);
begin
  if Assigned(Present)
  then begin
     MMAutoSize.Checked := not MMAutoSize.Checked;
     Present.AutoSize := MMAutoSize.Checked;
     // --------------------------------------
     Image1.Width  := PanelImg.Width  - 4;
     Image1.Height := PanelImg.Height - 4;
     //    
     Present.ReShowCurrentImage();
     // --------------------------------------
  end;
end;
// -------------------------------------------------------------------------
// 27.10.2016
//     
procedure TForm1.MMProportionalClick(Sender: TObject);
begin
  if Assigned(Present)
  then begin
     MMProportional.Checked := not MMProportional.Checked;
     Present.Proportional := MMProportional.Checked;
     // --------------------------------------
     Image1.Width  := PanelImg.Width  - 4;
     Image1.Height := PanelImg.Height - 4;
     //    
     Present.ReShowCurrentImage();
     // --------------------------------------
  end;
end;
// -------------------------------------------------------------------------
// 27.10.2016
//  -   *.jpg
procedure TForm1.MMOpenSlideClick(Sender: TObject);
begin
    //      
    if Assigned(Present)
    then Present.OpenOnePicture();
end;

// =========================================================================
//    
// =========================================================================
// -------------------------------------------------------------------------
// 04.11.2016
//  -   
procedure TForm1.T1BtnToFirstClick(Sender: TObject);
begin
  if not Assigned(PictShow) then Exit;
  PictShow.ShowFirstPicture;
end;
// -------------------------------------------------------------------------
// 04.11.2016
//  -   
procedure TForm1.T1BtnToPrevClick(Sender: TObject);
begin
  if not Assigned(PictShow) then Exit;
  PictShow.ShowPrevPicture;
end;
// -------------------------------------------------------------------------
// 04.11.2016
//  -    
procedure TForm1.T1BtnStopClick(Sender: TObject);
begin
  if not Assigned(PictShow) then Exit;
  PictShow.ShowStop;
end;
// -------------------------------------------------------------------------
// 04.11.2016
//  -    
procedure TForm1.T1BtnPlayClick(Sender: TObject);
begin
  if not Assigned(PictShow) then Exit;
  PictShow.ShowPlay;
end;
// -------------------------------------------------------------------------
// 04.11.2016
//      
procedure TForm1.CbBoxShowTempClick(Sender: TObject);
begin
  if not Assigned(PictShow) then Exit;
  case CbBoxShowTemp.ItemIndex of
    0 : PictShow.ShowTemp := 1000;
    1 : PictShow.ShowTemp := 2000;
    2 : PictShow.ShowTemp := 4000;
    3 : PictShow.ShowTemp := 8000;
    else PictShow.ShowTemp := 1000;
  end;
end;
// -------------------------------------------------------------------------
// 04.11.2016
//  -   
procedure TForm1.T1BtnToNextClick(Sender: TObject);
begin
  if not Assigned(PictShow) then Exit;
  PictShow.ShowNextPicture;
end;
// -------------------------------------------------------------------------
// 04.11.2016
//  -   
procedure TForm1.T1BtnToLastClick(Sender: TObject);
begin
  if not Assigned(PictShow) then Exit;
  PictShow.ShowLastPicture;
end;
// -------------------------------------------------------------------------
// 04.11.2016
//  -    
procedure TForm1.MMOpenShowClick(Sender: TObject);
begin
  if not Assigned(PictShow) then Exit;
  PictShow.LoadPictureShow;
  //   
  PictureShowActivate();
end;

// =========================================================================
// 
// =========================================================================







end.
